/*
 * Decompiled with CFR 0.152.
 */
package uni.dcloud.io.uniplugin_richalert;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.support.annotation.NonNull;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.utils.WXResourceUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;
import uni.dcloud.io.uniplugin_richalert.Info.Person;
import uni.dcloud.io.uniplugin_richalert.Info.SaxHelper;
import uni.dcloud.io.uniplugin_richalert.RichAlertWXModule;

public class RichAlert {
    public static String TITLE = "title";
    public static String TITLE_COLOR = "titleColor";
    int mPositiveColor = -16777216;
    int mNegativeColor = -16777216;
    int mNeutralColor = -16777216;
    int mPosition = 17;
    Context mContext;
    LinearLayout mContentViewRootView;
    CheckBox mCheckBox;
    TextView mMessageView;
    TextView mTitleView;
    AlertDialog mAlertDialog;
    AlertDialog.Builder mBuilder;
    String SELECTED = "isSelected";

    public RichAlert(@NonNull Context context) {
        this.mContext = context;
        this.mBuilder = new AlertDialog.Builder(context);
    }

    public void show() {
        this.mAlertDialog = this.mBuilder.create();
        if (this.mContentViewRootView != null) {
            this.mAlertDialog.setView((View)this.mContentViewRootView);
            if (this.mCheckBox != null) {
                LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
                layoutParams.leftMargin = this.dip2px(this.mContext, 11.0f);
                this.mContentViewRootView.addView((View)this.mCheckBox, (ViewGroup.LayoutParams)layoutParams);
            }
        }
        this.mAlertDialog.setCanceledOnTouchOutside(false);
        this.mAlertDialog.show();
        this.setButtonColor(-1, this.mPositiveColor);
        this.setButtonColor(-2, this.mNegativeColor);
        this.setButtonColor(-3, this.mNeutralColor);
        Window dialogWindow = this.mAlertDialog.getWindow();
        dialogWindow.setGravity(this.mPosition);
    }

    public RichAlert setTitle(CharSequence title, int Color, String align) {
        this.initContentView(this.mContext);
        if (this.mTitleView != null) {
            this.mTitleView.setVisibility(0);
            this.mTitleView.setText(title);
            this.mTitleView.setTextColor(Color);
            this.mTitleView.setGravity(this.getAlign(align) | 0x10);
        }
        return this;
    }

    public RichAlert setContent(String content, int Color, String align, JSCallback jsCallback) {
        try {
            this.initContentView(this.mContext);
            ArrayList<Person> data = this.readxmlForDom(content);
            if (data != null && data.size() > 0) {
                CharSequence ct = this.getContentCharSequence(data, jsCallback);
                this.mMessageView.setText(ct);
            } else {
                this.mMessageView.setText((CharSequence)content);
            }
            this.mMessageView.setTextColor(Color);
            this.mMessageView.setGravity(this.getAlign(align));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    private void initContentView(Context context) {
        if (this.mContentViewRootView == null && context != null) {
            this.mContentViewRootView = new LinearLayout(context);
            this.mContentViewRootView.setOrientation(1);
            LinearLayout titleLayout = new LinearLayout(context);
            this.mTitleView = new TextView(context);
            this.mTitleView.setGravity(17);
            this.mTitleView.setPadding(this.dip2px(this.mContext, 16.0f), 0, this.dip2px(this.mContext, 16.0f), 0);
            this.mTitleView.setTextSize(2, 17.0f);
            LinearLayout.LayoutParams titleParams = new LinearLayout.LayoutParams(-1, this.dip2px(this.mContext, 45.0f));
            titleLayout.addView((View)this.mTitleView, (ViewGroup.LayoutParams)titleParams);
            this.mTitleView.setVisibility(8);
            this.mContentViewRootView.addView((View)titleLayout, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
            ScrollView scrollView = new ScrollView(context);
            this.mMessageView = new TextView(context);
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
            params.topMargin = this.dip2px(context, 25.0f);
            params.bottomMargin = this.dip2px(context, 25.0f);
            params.leftMargin = this.dip2px(context, 16.0f);
            params.rightMargin = this.dip2px(context, 16.0f);
            this.mContentViewRootView.addView((View)scrollView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
            scrollView.addView((View)this.mMessageView, (ViewGroup.LayoutParams)params);
            this.mMessageView.setTextSize(2, 16.0f);
            this.mMessageView.setMovementMethod(LinkMovementMethod.getInstance());
        }
    }

    public RichAlert setButtons(JSONArray buttons, final JSCallback jsCallback) {
        if (buttons != null && buttons.size() > 0) {
            block5: for (int i = 0; i < buttons.size(); ++i) {
                JSONObject button = buttons.getJSONObject(i);
                String title = button.getString(TITLE);
                int color = WXResourceUtils.getColor((String)button.getString(TITLE_COLOR), (int)RichAlertWXModule.defColor);
                if (TextUtils.isEmpty((CharSequence)title)) continue;
                if (i > 2) {
                    return this;
                }
                final int index = i;
                DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n) {
                        JSONObject result = new JSONObject();
                        result.put("type", (Object)"button");
                        result.put("index", (Object)index);
                        jsCallback.invoke((Object)result);
                    }
                };
                switch (i) {
                    case 0: {
                        this.mBuilder.setNegativeButton((CharSequence)title, listener);
                        this.mNegativeColor = color;
                        continue block5;
                    }
                    case 1: {
                        this.mBuilder.setNeutralButton((CharSequence)title, listener);
                        this.mNeutralColor = color;
                        continue block5;
                    }
                    case 2: {
                        this.mBuilder.setPositiveButton((CharSequence)title, listener);
                        this.mPositiveColor = color;
                    }
                }
            }
        }
        return this;
    }

    private void setButtonColor(int type, int color) {
        Button button;
        if (this.mAlertDialog != null && (button = this.mAlertDialog.getButton(type)) != null) {
            button.setTextColor(color);
        }
    }

    public RichAlert setPosition(String position) {
        this.mPosition = this.getAlign(position);
        return this;
    }

    public RichAlert setCheckBox(JSONObject checkBox, final JSCallback jsCallback) {
        if (checkBox == null) {
            return this;
        }
        this.mCheckBox = new CheckBox(this.mContext);
        this.mCheckBox.setText((CharSequence)checkBox.getString(TITLE));
        int color = WXResourceUtils.getColor((String)checkBox.getString(TITLE_COLOR), (int)RichAlertWXModule.defColor);
        this.mCheckBox.setTextColor(color);
        boolean isSelected = false;
        if (checkBox.containsKey((Object)this.SELECTED)) {
            isSelected = checkBox.getBoolean(this.SELECTED);
        }
        this.mCheckBox.setChecked(isSelected);
        this.mCheckBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                JSONObject result = new JSONObject();
                result.put("type", (Object)"checkBox");
                result.put("isSelected", (Object)isChecked);
                jsCallback.invokeAndKeepAlive((Object)result);
            }
        });
        return this;
    }

    private CharSequence getContentCharSequence(ArrayList<Person> data, JSCallback jsCallback) {
        SpannableStringBuilder spannableString = new SpannableStringBuilder();
        for (Person person : data) {
            if (TextUtils.isEmpty((CharSequence)person.content)) continue;
            if (person.label.equalsIgnoreCase("a")) {
                this.setASpan(spannableString, person, jsCallback);
                continue;
            }
            spannableString.append((CharSequence)person.content);
        }
        return spannableString;
    }

    private void setASpan(SpannableStringBuilder spannableString, final Person person, final JSCallback jsCallback) {
        int start = spannableString.toString().length();
        spannableString.append((CharSequence)person.content);
        int end = spannableString.toString().length();
        ClickableSpan clickableSpan = new ClickableSpan(){

            public void onClick(View view) {
                JSONObject result = new JSONObject();
                result.put("type", (Object)"a");
                result.putAll((Map)person.attribute);
                jsCallback.invokeAndKeepAlive((Object)result);
            }
        };
        spannableString.setSpan((Object)clickableSpan, start, end, 33);
        ForegroundColorSpan foregroundColorSpan = new ForegroundColorSpan(-16776961);
        spannableString.setSpan((Object)foregroundColorSpan, start, end, 33);
    }

    private ArrayList<Person> readxmlForDom(String content) throws Exception {
        content = "<RichP>" + content + "</RichP>";
        ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes());
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SaxHelper helper = new SaxHelper();
        SAXParser parser = factory.newSAXParser();
        parser.parse((InputStream)is, (DefaultHandler)helper);
        return helper.getPersons();
    }

    public boolean isShowing() {
        return this.mAlertDialog == null ? false : this.mAlertDialog.isShowing();
    }

    public void dismiss() {
        if (this.mAlertDialog != null) {
            this.mAlertDialog.dismiss();
            this.mAlertDialog = null;
            this.mContentViewRootView.removeAllViews();
            this.mContentViewRootView = null;
            this.mMessageView = null;
            this.mTitleView = null;
            this.mCheckBox = null;
        }
    }

    public void setOnDismissListener(DialogInterface.OnDismissListener listener) {
        if (this.mAlertDialog != null) {
            this.mAlertDialog.setOnDismissListener(listener);
        }
    }

    public void setOnCancelListener(DialogInterface.OnCancelListener listener) {
        if (this.mAlertDialog != null) {
            this.mAlertDialog.setOnCancelListener(listener);
        }
    }

    private int dip2px(Context context, float dipValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    private int getAlign(String alignString) {
        int align = 17;
        if (!TextUtils.isEmpty((CharSequence)alignString)) {
            switch (alignString) {
                case "left": {
                    align = 3;
                    break;
                }
                case "right": {
                    align = 5;
                    break;
                }
                case "bottom": {
                    align = 80;
                }
            }
        }
        return align;
    }
}

