//
//  AppDelegate.swift
//  HBuilder-Integrate-Swift
//
//  Created by EICAPITAN on 17/5/17.
//  Copyright © 2017年 EICAPITAN. All rights reserved.
//

import UIKit



@UIApplicationMain
class AppDelegate: UIResponder, UIApplicationDelegate {
    var window: UIWindow?
    func application(_ application: UIApplication, didFinishLaunchingWithOptions launchOptions: [UIApplication.LaunchOptionsKey: Any]?) -> Bool {
        
        let navController:UINavigationController = UINavigationController.init(rootViewController: (window?.rootViewController!)!);
        window?.rootViewController = navController;

        // WebApp集成时使用参数
        return PDRCore.initEngineWihtOptions(launchOptions, with: PDRCoreRunMode.appClient);

        // Webview集成时使用参数
        return PDRCore.initEngineWihtOptions(launchOptions, with: PDRCoreRunMode.webviewClient);
    }
    
    
    func application(_ application: UIApplication, performActionFor shortcutItem: UIApplicationShortcutItem, completionHandler: @escaping (Bool) -> Void) {
        PDRCore.handle(PDRCoreSysEvent.peekQuickAction, with: shortcutItem)
        completionHandler(true);
    }

    func applicationWillResignActive(_ application: UIApplication) {
        PDRCore.instance().handle(PDRCoreSysEvent.resignActive, with: nil);
        // Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
        // Use this method to pause ongoing tasks, disable timers, and invalidate graphics rendering callbacks. Games should use this method to pause the game.
    }

    func applicationDidEnterBackground(_ application: UIApplication) {
        PDRCore.instance().handle(PDRCoreSysEvent.enterBackground, with: nil);
        // Use this method to release shared resources, save user data, invalidate timers, and store enough application state information to restore your application to its current state in case it is terminated later.
        // If your application supports background execution, this method is called instead of applicationWillTerminate: when the user quits.
    }

    func applicationWillEnterForeground(_ application: UIApplication) {
        PDRCore.instance().handle(PDRCoreSysEvent.enterForeGround, with: nil);
        // Called as part of the transition from the background to the active state; here you can undo many of the changes made on entering the background.
    }

    func applicationDidBecomeActive(_ application: UIApplication) {
        PDRCore.instance().handle(PDRCoreSysEvent.becomeActive, with: nil);
        // Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
    }


    
    func applicationWillTerminate(_ application: UIApplication) {
        PDRCore.destoryEngine();
        // Called when the application is about to terminate. Save data if appropriate. See also applicationDidEnterBackground:.
    }

    // open url

    func application(_ application: UIApplication, handleOpen url: URL) -> Bool {
        PDRCore.instance().handle(PDRCoreSysEvent.openURL, with: url);
        return true;
    }

    
    // push

    func application(_ application: UIApplication, didFailToRegisterForRemoteNotificationsWithError error: Error) {
        PDRCore.instance().handle(PDRCoreSysEvent.regRemoteNotificationsError, with: error);
    }
    
    
    func application(_ application: UIApplication, didRegisterForRemoteNotificationsWithDeviceToken deviceToken: Data) {
        PDRCore.instance().handle(PDRCoreSysEvent.revDeviceToken, with: deviceToken);
    }
    
    
    func application(_ application: UIApplication, didReceiveRemoteNotification userInfo: [AnyHashable : Any], fetchCompletionHandler completionHandler: @escaping (UIBackgroundFetchResult) -> Void) {
        PDRCore.instance().handle(PDRCoreSysEvent.revRemoteNotification, with: userInfo);
    }
    
    func application(_ application: UIApplication, didReceive notification: UILocalNotification) {
        PDRCore.instance().handle(PDRCoreSysEvent.revLocalNotification, with: notification);
    }
}

