//
//  PGPluginTest.swift
//  HBuilder-Integrate-Swift
//
//  Created by EICAPITAN on 17/5/18.
//  Copyright © 2017年 EICAPITAN. All rights reserved.
//

import Foundation
import LocalAuthentication

@objc(PGPluginTest)
class PGPluginTest: PGPlugin {
    
    var glcbid : String? = nil;
    var Result : PDRPluginResult? = nil
    var webObj : H5WEWebEngine? = nil
    var arguArray : Array<AnyObject>?
    override func onAppStarted(_ options: [AnyHashable : Any]!) {
        // 应用启动时会触发这个方法，
    }
    
    override func onAppTerminate() -> ()
    {
        
    }
    
    override func onAppEnterBackground() -> ()
    {
        
    }
    // 应用进入前时触发
    override func onAppEnterForeground() -> ()
    {
        NSLog("APPDelegate applicationWillEnterForeground 事件触发时触发");
    }
    
    @objc func PluginTestFunction(_ commands:PGMethod?) -> ()
    {
        if commands == nil {
            return;
        }
        // CallBackid 异步方法的回调id，H5+ 会根据回调ID通知JS层运行结果成功或者失败
        let cbid : String = (commands?.arguments?[0])! as! String;
        // 用户的参数会在第二个参数传回,传入的顺序和JS层参数传递的顺序一致
        let pArgument1 : String = (commands?.arguments?[1])! as! String;
        let pArgument2 : String = (commands?.arguments?[2])! as! String;
        let pArgument3 : String = (commands?.arguments?[3])! as! String;
        let pArgument4 : String = (commands?.arguments?[4])! as! String;
        // 如果使用Array方式传递参数
        let pResultString : NSArray? = [pArgument1, pArgument2, pArgument3, pArgument4];
        
        // 运行Native代码结果和预期相同，调用回调通知JS层运行成功并返回结果
        // PDRCommandStatusOK 表示触发JS层成功回调方法
        // PDRCommandStatusError 表示触发JS层错误回调方法
        
        // 如果方法需要持续触发页面回调，可以通过修改 PDRPluginResult 对象的keepCallback 属性值来表示当前是否可重复回调， true 表示可以重复回调   false 表示不可重复回调  默认值为false       
        self.toCallback(cbid, withReslut: SWPluginResult.CallBackCommand(status: PDRCommandStatusOK, message: pResultString as Any));
    }
    
   @objc func PluginTestFunctionSync(_ commands: PGMethod?) -> Data! {
        // 根据传入获取参数
        let pArgument1 : String = (commands?.arguments?[0])! as! String;
        let pArgument2 : String = (commands?.arguments?[1])! as! String;
        let pArgument3 : String = (commands?.arguments?[2])! as! String;
        let pArgument4 : String = (commands?.arguments?[3])! as! String;
        // 拼接成字符串
        let retValuel = pArgument1 + " " + pArgument2 + " " + pArgument3 + " " + pArgument4;
        // 按照字符串方式返回结果
        return self.result(with: retValuel as String);
    }
    
    
    @objc func AuthenticateUser(_ commands:PGMethod!)
    {
        if (nil == commands){
            return;
        }
        
        var laerror :NSError?
        var pResult :String?
        let cbid  = commands?.arguments?[0] as! String?;
        let LocalReason = "HBuilder指纹验证";
        var strError    = Dictionary<String, Any>();
        var resultCommand = Int(PDRCommandStatusError.rawValue);
        
        // Touch ID 是IOS 8 以后支持的功能
        if(PTDeviceOSInfo.systemVersion().rawValue >= PTSystemVersion.version8Series.rawValue)
        {
            let context:LAContext? = LAContext.init();
            if( context?.canEvaluatePolicy(LAPolicy.deviceOwnerAuthenticationWithBiometrics, error: &laerror))!
            {
                context?.evaluatePolicy(LAPolicy.deviceOwnerAuthenticationWithBiometrics, localizedReason: LocalReason, reply: { (sucess:Bool, error:NSError?) in
                    if sucess
                    {
                        resultCommand = Int(PDRCommandStatusOK.rawValue);
                        strError = ["state":0, "message":"成功"];
                    }
                    else{
                        
                        switch error!.code
                        {
                        case LAError.systemCancel.rawValue:
                            strError = ["state":-1, "message":"系统取消授权(例如其他APP切入)"];
                            break;
                        case LAError.userCancel.rawValue:
                            strError = ["state":-2, "message":"用户取消Touch ID授权"];
                            break;
                        case LAError.userFallback.rawValue:
                            strError = ["state":-3, "message":"用户选择输入密码"];
                            break;
                        case LAError.touchIDNotAvailable.rawValue:
                            strError = ["state":-4, "message":"设备Touch ID不可用"];
                            break;
                        case LAError.touchIDLockout.rawValue:
                            strError = ["state":-5, "message":"Touch ID被锁"];
                            break;
                        case LAError.appCancel.rawValue:
                            strError = ["state":-6, "message":"软件被挂起取消授权"];
                            break;
                        default:
                            strError = ["state":-7, "message":"其他错误"];
                            break;
                        }
                    }
                }as! (Bool, Error?) -> Void);
            }else{
                
                switch laerror!.code
                {
                case LAError.touchIDNotEnrolled.rawValue:
                    strError = ["state":-11, "message":"设备Touch ID不可用"];
                    break;
                case LAError.passcodeNotSet.rawValue:
                    strError = ["state":-12, "message":"用户未录入Touch ID"];
                default:
                    break;
                }
            }
            
            pResult = SWPluginResult.CallBackCommand(status: PDRCommandStatus(rawValue: UInt32(resultCommand)), message: strError);
            self.toCallback(cbid, withReslut: pResult)
            return;
        }
        
        self.toCallback(cbid, withReslut: "Device Not Support")
    }
    
    
    // 步回调将数据返回给页面
   @objc func PluginTestFunctionSyncArrayArgu(_ commands: PGMethod?) ->Data!
    {
        
        arguArray = (commands?.arguments?[0])! as? Array;
        let arr = ["RetArgu1","RetArgu2","RetArgu3", "RetArgu4"];
        
        let arguDic = NSDictionary(objects: arguArray!, forKeys: arr as [NSCopying]);
        
        
        webObj = self.jsFrameContext.webEngine;
        self.perform(#selector(asyncToWebView), with: nil, afterDelay: 2)
        
        return  self.result(withJSON: (arguDic as! [AnyHashable : Any]));
    }
    
    // 将数据返回
    @objc func asyncToWebView()  -> ()
    {
        webObj?.evaluateJavaScript("alert('原生将数据返回到js层')", completionHandler: nil);
    }
}
