//
//  ViewController.swift
//  HBuilder-Integrate-Swift
//
//  Created by EICAPITAN on 17/5/17.
//  Copyright © 2017年 EICAPITAN. All rights reserved.
//

import UIKit



class ViewController: UIViewController {
    
    var WebAppButton : UIButton?
    var WebViewButton: UIButton?
    var buttonWidth : CGFloat? = 300
    var buttonHeight : CGFloat? = 50
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view, typically from a nib.
        
        var ButtonYPos : CGFloat = 100;
        let ButtonYMargin : CGFloat = 50;
        
        let ButtonXpos:CGFloat = (self.view.frame.size.width - buttonWidth!)/2;
        WebViewButton = UIButton.init(type: UIButton.ButtonType.custom);
        WebViewButton?.frame = CGRect(x:ButtonXpos, y: ButtonYPos , width: buttonWidth!, height: buttonHeight!);
        WebViewButton?.setTitle("WebView集成方式", for: UIControl.State.normal);
        WebViewButton?.setTitleColor(UIColor.black, for: UIControl.State.normal);
        WebViewButton?.addTarget(self, action:#selector(onButtonClick(_:)), for: UIControl.Event.touchUpInside);
        WebViewButton?.tag = 1;
        
        
        ButtonYPos += buttonHeight!;
        ButtonYPos += ButtonYMargin;
        
        WebAppButton = UIButton.init(type: UIButton.ButtonType.custom);
        WebAppButton?.frame = CGRect(x:ButtonXpos , y:ButtonYPos, width: buttonWidth!, height: buttonHeight!);
        WebAppButton?.setTitleColor(UIColor.black, for: UIControl.State.normal);
        WebAppButton?.setTitle("WebApp集成方式", for: UIControl.State.normal);
        WebAppButton?.addTarget(self, action: #selector(onButtonClick(_:)), for: UIControl.Event.touchUpInside);
        WebAppButton?.tag = 2;
        
        
        
        self.view.addSubview(WebViewButton!);
        self.view.addSubview(WebAppButton!);
        
        
        NotificationCenter.default.addObserver(self, selector: #selector(testFunction(_:)), name: NSNotification.Name(rawValue: "SendDataToNative"), object: nil);
    }
    
    @objc func testFunction(_ not:NSNotification){
        let pRecData = not.object;
        if (pRecData != nil) {
            print("Native Receive Data:%@", pRecData as Any);
            let alertController = UIAlertController.init(title: "", message: "原生层收到从js层来的数据", preferredStyle: .alert);
            let okAction = UIAlertAction(title: "好的", style: .default, handler: nil)
            alertController.addAction(okAction)
            self.present(alertController, animated: true, completion: nil)
        }
    }

    
    @objc func onButtonClick(_ button: UIButton) -> () {

        if(button.tag == 1){
            if ( PDRCoreRunMode.webviewClient != PDRCore.instance().runMode) {
                let alertController = UIAlertController.init(title: "", message: "请在appdelegate切换启动模式为PDRCoreRunModeWebviewClient", preferredStyle: .alert);
                let cancelAction = UIAlertAction(title: "取消", style: .cancel, handler: nil)
                let okAction = UIAlertAction(title: "好的", style: .default, handler: nil)
                alertController.addAction(cancelAction)
                alertController.addAction(okAction)
                self.present(alertController, animated: true, completion: nil)
                return ;
            }
            let webViewPage:WebViewController? = WebViewController();
            self.navigationController?.pushViewController(webViewPage!, animated: true);
            
        }else if(button.tag == 2){
            if ( PDRCoreRunMode.appClient != PDRCore.instance().runMode) {
                let alertController = UIAlertController.init(title: "", message: "请在appdelegate切换启动模式为PDRCoreRunModeAppClient", preferredStyle: .alert);
                let cancelAction = UIAlertAction(title: "取消", style: .cancel, handler: nil)
                let okAction = UIAlertAction(title: "好的", style: .default, handler: nil)
                alertController.addAction(cancelAction)
                alertController.addAction(okAction)
                self.present(alertController, animated: true, completion: nil)
                return;
            }
            let webAppPage:WebAppController? = WebAppController();
            self.navigationController?.isNavigationBarHidden = true;
            self.navigationController?.pushViewController(webAppPage!, animated: true);            
        }
        
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

