//
//  WebViewController.swift
//  HBuilder-Integrate-Swift
//
//  Created by EICAPITAN on 17/5/18.
//  Copyright © 2017年 EICAPITAN. All rights reserved.
//

import Foundation

class WebViewController: UIViewController,PDRCoreDelegate {
    
    var webFrame: PDRCoreAppFrame?
    
    override func loadView() {
        super.loadView();
        self.view.backgroundColor = UIColor.orange;
    }
    
    override func viewDidLoad() {
        let pCoreHandle : PDRCore? = PDRCore.instance();
        if(pCoreHandle != nil)
        {
            let pFilePath:String? = String.localizedStringWithFormat("file://%@/%@", Bundle.main.bundlePath, "Pandora/apps/HelloH5/www/plugin.html" );
            let basePath:String? = String.localizedStringWithFormat("file://%@/%@", Bundle.main.bundlePath,"Pandora/apps/");
            pCoreHandle?.start();
            pCoreHandle?.coreDeleagete = self;
            pCoreHandle?.persentViewController = self;
            
            webFrame = PDRCoreAppFrame.init(name: "WebViewId", loadURL: pFilePath!, baseURL: basePath!, frame:self.view.bounds);
            if (webFrame != nil) {
                let activeApp:PDRCoreApp = pCoreHandle?.appManager.activeApp as! PDRCoreApp;
                activeApp.appWindow.registerFrame(webFrame);
            }
            self.view.addSubview(webFrame!);
        }
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
}
